<?php
/**
 * The template for displaying the footer.
 *
 * Contains the body & html closing tags.
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'footer' ) ) {
	get_template_part( 'template-parts/footer' );
}
?>

<?php wp_footer(); ?>

<link rel="stylesheet" type="text/css" href="<?php echo get_site_url(); ?>/wp-content/themes/hello-elementor/slick/slick.css"/>
<script type="text/javascript" src="<?php echo get_site_url(); ?>/wp-content/themes/hello-elementor/slick/slick.min.js"></script>


<script type="text/javascript">
    jQuery( document ).ready(function() {
        var altura = jQuery('.home-sec1').offset().top;

        if ( jQuery(window).scrollTop() > altura ){
                jQuery('.header-main').addClass('header-main-fixed');
            } else {
                jQuery('.header-main').removeClass('header-main-fixed');
            }

        jQuery(window).on('scroll', function(){
            if ( jQuery(window).scrollTop() > altura ){
                jQuery('.header-main').addClass('header-main-fixed');
            } else {
                jQuery('.header-main').removeClass('header-main-fixed');
            }
        });


        jQuery(".col-portafolio").click(function() {
            jQuery(".pop-portafolio-container").addClass("open-pop-portafolio");
        });

        jQuery(".close-pop-button").click(function() {
            jQuery(".pop-portafolio-container").removeClass("open-pop-portafolio");
        });


        jQuery('.pop-portafolio').slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: true,
            fade: true,
            dots: true,
            adaptiveHeight: true,
            asNavFor: '.row-portafolio',
            dotsClass: 'custom_paging',
            customPaging: function (slider, i) {
                return (i + 1) + ' de ' + slider.slideCount;
            }
        });

        jQuery('.row-portafolio').slick({
            slidesToShow: 3,
            slidesToScroll: 1,
            asNavFor: '.pop-portafolio',
            dots: false,
            infinite: false,
            arrows: false,
            centerMode: false,
            focusOnSelect: true
        });

        jQuery('.it-sec2 .elementor-widget-image-gallery .gallery').slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            dots: false,
            infinite: true,
            arrows: true,
            autoplay: true,
            autoplaySpeed: 3000,
        });

        /*BARRA DE PROGRESO FORMULARIO*/
        
        // Número total de campos a completar
        var totalCampos = jQuery('span .wpcf7-form-control').length;

        // Función para actualizar la barra de carga
        function actualizarBarra() {
            // Contamos los campos completados
            var camposCompletados = jQuery('span .wpcf7-form-control').filter(function() {
                return jQuery(this).val() !== ''; // Filtramos los campos no vacíos
            }).length;

            // Calculamos el porcentaje
            var porcentaje = (camposCompletados / totalCampos) * 100;

            // Actualizamos el ancho de la barra
            jQuery('#form_bar_progress').css('height', porcentaje + '%');
        }

        // Cuando un campo se llena, actualizamos la barra
        jQuery('span .wpcf7-form-control').on('input', function() {
        actualizarBarra();
        });

        // También actualizamos la barra al cargar la página
        actualizarBarra();



    });
</script>

</body>
</html>
