<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package understrap
 */
$container = get_theme_mod( 'understrap_container_type' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-title" content="<?php bloginfo( 'name' ); ?> - <?php bloginfo( 'description' ); ?>">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php wp_head(); ?>
	<link rel="icon" href="<?php echo get_template_directory_uri(); ?>/favicon.png">
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style.css">
</head>

<body <?php body_class(); ?>>

<div class="container-fluid">
	<header>
			<div class="logo" align="center">
				<a class="nav-link-custom" href="<?php echo site_url(); ?>/#home">
					<img src="<?php echo site_url(); ?>/wp-content/uploads/2019/02/logo.png" class="img-responsive">
				</a>
			</div>
			<div class="mobile-toggle">
				<div class="button_container" id="toggle">
					<span class="top"></span>
					<span class="bottom"></span>
				</div>
			</div>
			<div class="mobile-menu">
				<div class="Menu">
				  <ul class="Menu-list" data-offset="8">
				    <li class="Menu-list-item" data-offset="4">
				      <a class="nav-link-custom" href="#marketing-digital">
						MARKETING DIGITAL
						<span class="Mask"><span>MARKETING DIGITAL</span></span>
						<span class="Mask"><span>MARKETING DIGITAL</span></span>
				      </a>
				    </li>
				    <li class="Menu-list-item" data-offset="4">
				      <a class="nav-link-custom" href="#desarrollo-web">
						DESARROLLO WEB
						<span class="Mask"><span>DESARROLLO WEB</span></span>
						<span class="Mask"><span>DESARROLLO WEB</span></span>
				      </a>
				    </li>
				    <li class="Menu-list-item" data-offset="4">
				      <a class="nav-link-custom" href="#branding">
						BRANDING
						<span class="Mask"><span>BRANDING</span></span>
						<span class="Mask"><span>BRANDING</span></span>
				      </a>
				    </li>
				    <li class="Menu-list-item" data-offset="4">
				      <a class="nav-link-custom" href="#publicidad">
						PUBLICIDAD
						<span class="Mask"><span>PUBLICIDAD</span></span>
						<span class="Mask"><span>PUBLICIDAD</span></span>
				      </a>
				    </li>
				    <li class="Menu-list-item" data-offset="4">
				      <a class="nav-link-custom" href="#foto-video">
						FOTO Y VIDEO
						<span class="Mask"><span>FOTO Y VIDEO</span></span>
						<span class="Mask"><span>FOTO Y VIDEO</span></span>
				      </a>
				    </li>
				    
				  </ul>
				</div>
			</div>
		</header>